/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.Serializable;
import jclass.datasource.DataModelException;
import jclass.datasource.components.ExceptionHandler;
import jclass.util.MessageDialog;

public class ExceptionManager
implements ExceptionHandler,
Serializable {
    protected static ExceptionHandler handler = new ExceptionManager();
    protected boolean writeToConsole = false;

    public static final ExceptionHandler getHandler() {
        return handler;
    }

    public static final void setHandler(ExceptionHandler exceptionHandler) {
        handler = exceptionHandler;
    }

    public ExceptionManager() {
    }

    public ExceptionManager(boolean bl) {
        this.writeToConsole = bl;
    }

    private static Frame getFrame(Component component) {
        Window window = ExceptionManager.getWindow(component);
        if (window instanceof Dialog && window.getParent() instanceof Window) {
            window = (Window)window.getParent();
        }
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private static Window getWindow(Component component) {
        Component component2 = component;
        Component component3 = component;
        while (component3 != null && !(component3 instanceof Window)) {
            component3 = component2;
            if (component2 == null) {
                return null;
            }
            component2 = component2.getParent();
        }
        return (Window)component3;
    }

    public void showException(Component component, String string, String string2) {
        if (component != null) {
            new MessageDialog(ExceptionManager.getFrame(component), string, string2);
        }
        if (component == null || this.writeToConsole) {
            System.err.println(string2);
        }
    }

    public void processException(Component component, DataModelException dataModelException) {
        String string = dataModelException.getMessage();
        if (string == null || string.length() == 0) {
            string = dataModelException.toString();
        }
        this.showException(component, "DataSource Exception", string);
    }
}

